@extends('layouts.app')

@section('title', 'Tutoriais')

@section('content')
<div class="slim-mainpanel">
    <div class="container">
        @if(session('success'))
        <div class="alert alert-solid alert-success" role="alert">
            <strong>Sucesso!</strong> {{ session('success') }}
        </div>
        @endif

        @if(request('message'))
        <div class="alert alert-solid alert-success" role="alert">
            <strong>Sucesso!</strong> {{ urldecode(request('message')) }}
        </div>
        @endif

        {{-- Formulário para admin adicionar vídeo --}}
        @if($user->tipo == 1)
        <div class="card video-card mg-b-20">
            <div class="card-header">
                <i class="fa fa-plus-circle mg-r-5"></i> Adicionar Vídeo
            </div>
            <div class="card-body">
                <form id="videoForm" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="title">Título do Vídeo <span class="tx-danger">*</span></label>
                                <input type="text" name="title" id="title" class="form-control" 
                                    placeholder="Insira o título do vídeo" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="link">Código do Vídeo <span class="tx-danger">*</span></label>
                                <input type="text" name="link" id="link" class="form-control" 
                                    placeholder="Ex: i6gEcyFmJDc" required>
                                <small class="form-text text-muted">
                                    Para o vídeo 'https://youtu.be/i6gEcyFmJDc', o código é 'i6gEcyFmJDc'
                                </small>
                            </div>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-check mg-r-5"></i> Adicionar Vídeo
                    </button>
                </form>
            </div>
        </div>
        @endif

        {{-- Lista de vídeos --}}
        @if($user->tipo == 1 || $user->tipo == 2)
        <div class="section-wrapper">
            <label class="section-title">
                <i class="fa fa-youtube-play" aria-hidden="true"></i> Vídeos Tutoriais
            </label>
            <hr>
            
            <div class="row">
                @forelse($videos as $video)
                <div class="col-md-3 mb-4">
                    <div class="card video-card">
                        <div class="card-body">
                            <h5 class="card-title">{{ $video->title }}</h5>
                            <iframe width="100%" height="200" 
                                src="https://www.youtube.com/embed/{{ $video->link }}" 
                                frameborder="0"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                allowfullscreen>
                            </iframe>
                            
                            @if($user->tipo == 1)
                            <div class="d-flex justify-content-center align-items-center mg-t-10">
                                <a href="{{ route('videos.edit', $video->id) }}" class="btn btn-warning btn-sm mg-r-5">
                                    <i class="fa fa-pencil"></i> Editar
                                </a>
                                <button onclick="confirmDelete({{ $video->id }})" class="btn btn-danger btn-sm">
                                    <i class="fa fa-trash"></i> Excluir
                                </button>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                @empty
                <div class="col-12">
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle mg-r-5"></i> Nenhum vídeo cadastrado ainda.
                    </div>
                </div>
                @endforelse
            </div>
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
$(document).ready(function(){
    $('#videoForm').on('submit', function(e){
        e.preventDefault();
        
        $.ajax({
            url: '{{ route("videos.store") }}',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response){
                if (response.success) {
                    swal({
                        title: "Sucesso!",
                        text: response.message,
                        icon: "success",
                        button: "OK",
                    }).then(() => {
                        window.location.reload();
                    });
                } else {
                    swal({
                        title: "Erro!",
                        text: response.message,
                        icon: "error",
                        button: "OK",
                    });
                }
            },
            error: function(xhr){
                swal({
                    title: "Erro!",
                    text: "Erro ao adicionar vídeo.",
                    icon: "error",
                    button: "OK",
                });
            }
        });
    });
});

function confirmDelete(id) {
    swal({
        title: "Tem certeza?",
        text: "Uma vez excluído, você não poderá recuperar este vídeo!",
        icon: "warning",
        buttons: ["Cancelar", "Sim, excluir"],
        dangerMode: true,
    }).then((willDelete) => {
        if (willDelete) {
            $.ajax({
                url: '/master/videos/' + id,
                type: 'DELETE',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                success: function(response){
                    swal("Vídeo deletado com sucesso!", {
                        icon: "success",
                    }).then(() => {
                        window.location.reload();
                    });
                },
                error: function(){
                    swal("Erro ao deletar vídeo!", {
                        icon: "error",
                    });
                }
            });
        }
    });
}
</script>
@endpush

