

<?php $__env->startSection('content'); ?>
<!-- Chart.js para gráficos -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
  /* Estilos customizados */
  .stat-card {
    transition: all 0.3s ease;
  }
  .stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
  }
  .chart-container {
    position: relative;
    height: 300px;
  }
  
  /* Estilos para truncamento de texto */
  .text-truncate-cell {
    max-width: 150px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    cursor: pointer;
    position: relative;
  }

  .text-truncate-cell:hover {
    background-color: #f8f9fa;
    border-radius: 4px;
    padding: 2px 4px;
  }

  .text-truncate-cell.expanded {
    white-space: normal !important;
    word-wrap: break-word !important;
    max-width: 300px !important;
    background-color: #fff !important;
    border: 2px solid #dc3545 !important;
    border-radius: 6px !important;
    padding: 10px !important;
    box-shadow: 0 4px 15px rgba(0,0,0,0.2) !important;
    z-index: 1000 !important;
    position: relative !important;
    transform: scale(1.02) !important;
  }
  
  /* Estilos para DataTable responsivo */
  .table-responsive {
    border-radius: 8px;
    overflow: hidden;
  }
  
  .dataTables_wrapper .dataTables_paginate .paginate_button {
    padding: 0.5rem 0.75rem;
    margin: 0 2px;
    border-radius: 6px;
    border: 1px solid #dee2e6;
    background: #fff;
    color: #6c757d;
    transition: all 0.3s ease;
  }
  
  .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
    background: #007bff;
    color: #fff;
    border-color: #007bff;
  }
  
  .dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: #007bff;
    color: #fff;
    border-color: #007bff;
  }
</style>

<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
  <h6 class="fw-semibold mb-0">Relatório de Envios WhatsApp</h6>
  <ul class="d-flex align-items-center gap-2">
    <li class="fw-medium">
      <a href="<?php echo e(route('dashboard')); ?>" class="d-flex align-items-center gap-1 hover-text-primary">
        <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
        Dashboard
      </a>
    </li>
    <li>-</li>
    <li class="fw-medium">Relatório WhatsApp</li>
  </ul>
</div>

<!-- Filtros Inteligentes -->
<div class="card mb-4">
  <div class="card-header">
    <h6 class="mb-0 d-flex align-items-center">
      <iconify-icon icon="solar:filter-outline" class="text-primary me-2" style="font-size: 18px;"></iconify-icon>
      Filtros de Data
    </h6>
  </div>
  <div class="card-body">
    <form method="GET" class="row g-3">
      <div class="col-lg-3 col-md-6">
        <label class="form-label fw-medium">Período Rápido</label>
        <select name="periodo" class="form-select" id="periodoSelect" onchange="toggleCustomDates()">
          <option value="hoje" <?php echo e($periodo == 'hoje' ? 'selected' : ''); ?>>Hoje</option>
          <option value="ontem" <?php echo e($periodo == 'ontem' ? 'selected' : ''); ?>>Ontem</option>
          <option value="ultima_semana" <?php echo e($periodo == 'ultima_semana' ? 'selected' : ''); ?>>Última Semana</option>
          <option value="mes_atual" <?php echo e($periodo == 'mes_atual' ? 'selected' : ''); ?>>Mês Atual</option>
          <option value="ultimo_mes" <?php echo e($periodo == 'ultimo_mes' ? 'selected' : ''); ?>>Último Mês</option>
          <option value="ultimo_trimestre" <?php echo e($periodo == 'ultimo_trimestre' ? 'selected' : ''); ?>>Último Trimestre</option>
          <option value="ano_atual" <?php echo e($periodo == 'ano_atual' ? 'selected' : ''); ?>>Ano Atual</option>
          <option value="ultimo_ano" <?php echo e($periodo == 'ultimo_ano' ? 'selected' : ''); ?>>Último Ano</option>
          <option value="personalizado" <?php echo e($periodo == 'personalizado' ? 'selected' : ''); ?>>Personalizado</option>
        </select>
      </div>
      
      <div class="col-lg-2 col-md-6" id="dataInicioDiv" style="display: <?php echo e($periodo == 'personalizado' ? 'block' : 'none'); ?>;">
        <label class="form-label fw-medium">Data Início</label>
        <input type="date" name="data_inicio" class="form-control" value="<?php echo e($dataInicio); ?>" id="dataInicio">
      </div>
      
      <div class="col-lg-2 col-md-6" id="dataFimDiv" style="display: <?php echo e($periodo == 'personalizado' ? 'block' : 'none'); ?>;">
        <label class="form-label fw-medium">Data Fim</label>
        <input type="date" name="data_fim" class="form-control" value="<?php echo e($dataFim); ?>" id="dataFim">
      </div>
      
      <div class="col-lg-3 col-md-6">
        <label class="form-label fw-medium">Gateway</label>
        <select name="gateway" class="form-select">
          <option value="todos" <?php echo e($gatewayFiltro == 'todos' || empty($gatewayFiltro) ? 'selected' : ''); ?>>Todos os Gateways</option>
          <option value="1" <?php echo e($gatewayFiltro == '1' ? 'selected' : ''); ?>>Mercado Pago</option>
          <option value="2" <?php echo e($gatewayFiltro == '2' ? 'selected' : ''); ?>>PIX Manual</option>
          <option value="4" <?php echo e($gatewayFiltro == '4' ? 'selected' : ''); ?>>PagHiper</option>
          <option value="5" <?php echo e($gatewayFiltro == '5' ? 'selected' : ''); ?>>Asaas</option>
        </select>
      </div>
      
      <div class="col-lg-2 col-md-6 d-flex align-items-end">
        <button type="submit" class="btn btn-primary w-100 d-flex align-items-center justify-content-center">
          <iconify-icon icon="solar:magnifer-outline" class="me-1" style="font-size: 16px;"></iconify-icon>
          Filtrar
        </button>
      </div>
    </form>
    
    <!-- Resumo do Período Selecionado -->
    <div class="mt-3">
      <div class="alert alert-info d-flex align-items-center">
        <iconify-icon icon="solar:calendar-outline" class="text-info me-2" style="font-size: 18px;"></iconify-icon>
        <span class="fw-medium">Filtros aplicados:</span>
        <span class="ms-2">
          <?php echo e(\Carbon\Carbon::parse($dataInicio)->format('d/m/Y')); ?> até <?php echo e(\Carbon\Carbon::parse($dataFim)->format('d/m/Y')); ?>

          <?php if($dataInicio == $dataFim): ?>
            (1 dia)
          <?php else: ?>
            (<?php echo e($diasPeriodo); ?> dias)
          <?php endif; ?>
          
          <?php if(!empty($gatewayFiltro) && $gatewayFiltro !== 'todos'): ?>
            | Gateway: 
            <?php if($gatewayFiltro == '1'): ?> Mercado Pago
            <?php elseif($gatewayFiltro == '2'): ?> PIX Manual
            <?php elseif($gatewayFiltro == '4'): ?> PagHiper
            <?php elseif($gatewayFiltro == '5'): ?> Asaas
            <?php else: ?> Gateway <?php echo e($gatewayFiltro); ?>

            <?php endif; ?>
          <?php endif; ?>
        </span>
      </div>
    </div>
  </div>
</div>

<!-- Cards de Estatísticas -->
<div class="row gy-4 mb-4">
  <div class="col-xxl-3 col-sm-6">
    <div class="card stat-card p-3 radius-8 border-0 bg-gradient-start-1 h-100">
      <div class="card-body p-20">
        <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
          <div class="flex-grow-1">
            <p class="fw-medium text-primary-light mb-1">Total de Envios</p>
            <h6 class="mb-0"><?php echo e(number_format($totalEnvios, 0, ',', '.')); ?></h6>
          </div>
          <div class="w-44-px h-44-px radius-8 d-flex justify-content-center align-items-center bg-primary-600">
            <iconify-icon icon="mdi:whatsapp" class="text-white text-2xl"></iconify-icon>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-xxl-3 col-sm-6">
    <div class="card stat-card p-3 radius-8 border-0 bg-gradient-start-2 h-100">
      <div class="card-body p-20">
        <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
          <div class="flex-grow-1">
            <p class="fw-medium text-success-light mb-1">Envios com Sucesso</p>
            <h6 class="mb-0"><?php echo e(number_format($enviosSucesso, 0, ',', '.')); ?></h6>
            <small class="text-success-600 fw-bold"><?php echo e(number_format($taxaSucesso, 1)); ?>%</small>
          </div>
          <div class="w-44-px h-44-px radius-8 d-flex justify-content-center align-items-center bg-success-600">
            <iconify-icon icon="mdi:check-circle" class="text-white text-2xl"></iconify-icon>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-xxl-3 col-sm-6">
    <div class="card stat-card p-3 radius-8 border-0 bg-gradient-start-3 h-100">
      <div class="card-body p-20">
        <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
          <div class="flex-grow-1">
            <p class="fw-medium text-danger-light mb-1">Envios com Falha</p>
            <h6 class="mb-0"><?php echo e(number_format($enviosFalha, 0, ',', '.')); ?></h6>
            <small class="text-danger-600 fw-bold"><?php echo e(number_format(100 - $taxaSucesso, 1)); ?>%</small>
          </div>
          <div class="w-44-px h-44-px radius-8 d-flex justify-content-center align-items-center bg-danger-600">
            <iconify-icon icon="mdi:close-circle" class="text-white text-2xl"></iconify-icon>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-xxl-3 col-sm-6">
    <div class="card stat-card p-3 radius-8 border-0 bg-gradient-start-4 h-100">
      <div class="card-body p-20">
        <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
          <div class="flex-grow-1">
            <p class="fw-medium text-warning-light mb-1">Pendentes</p>
            <h6 class="mb-0"><?php echo e(number_format($enviosPendentes, 0, ',', '.')); ?></h6>
            <small class="text-warning-600 fw-bold" style="visibility: hidden;">0.0%</small>
          </div>
          <div class="w-44-px h-44-px radius-8 d-flex justify-content-center align-items-center bg-warning-600">
            <iconify-icon icon="mdi:clock-outline" class="text-white text-2xl"></iconify-icon>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Gráficos -->
<div class="row gy-4 mb-4">
  <!-- Gráfico de Linha - Envios por Dia -->
  <div class="col-md-8">
    <div class="card">
      <div class="card-header">
        <h6 class="mb-0">Envios nos Últimos 7 Dias</h6>
      </div>
      <div class="card-body">
        <div class="chart-container">
          <canvas id="chartEnviosPorDia"></canvas>
        </div>
      </div>
    </div>
  </div>

  <!-- Gráfico de Pizza - Sucesso vs Falha -->
  <div class="col-md-4">
    <div class="card">
      <div class="card-header">
        <h6 class="mb-0">Taxa de Sucesso</h6>
      </div>
      <div class="card-body">
        <div class="chart-container">
          <canvas id="chartSucessoFalha"></canvas>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Tabela Detalhada -->
<div class="card">
  <div class="card-header d-flex justify-content-between align-items-center">
    <h6 class="mb-0">Histórico Detalhado de Envios</h6>
    <div>
      <button class="btn btn-sm btn-primary" onclick="window.print()">
        <i class="ri-printer-line me-1"></i> Imprimir
      </button>
    </div>
  </div>
  <div class="card-body">
    <div class="table-responsive">
      <table class="table bordered-table mb-0 display responsive nowrap w-100" id="whatsappTable" data-page-length="25">
        <thead>
          <tr align="center">
            <th>Data/Hora</th>
            <th>Cliente</th>
            <th>Telefone</th>
            <th>Tipo</th>
            <th class="d-none d-lg-table-cell">Gateway</th>
            <th class="d-none d-md-table-cell">Valor</th>
            <th>Status</th>
            <th class="d-none d-xl-table-cell">Origem</th>
          </tr>
        </thead>
        <tbody>
          <?php $__empty_1 = true; $__currentLoopData = $historico; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $envio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
          <tr>
            <td>
              <div class="d-flex flex-column">
                <span class="fw-medium"><?php echo e($envio->data_envio->format('d/m/Y')); ?></span>
                <small class="mb-16 text-secondary-light text-sm"><?php echo e($envio->data_envio->format('H:i')); ?></small>
              </div>
            </td>
            <td>
              <div class="text-truncate-cell" style="max-width: 150px;" title="<?php echo e($envio->cliente_nome ?? 'N/A'); ?>">
                <?php echo e($envio->cliente_nome ?? 'N/A'); ?>

              </div>
            </td>
            <td>
              <span class="fw-medium"><?php echo e($envio->telefone); ?></span>
            </td>
            <td>
              <span class="badge bg-<?php echo e($envio->tipo == 'cobranca' ? 'warning' : 
                ($envio->tipo == 'pix_codigo' ? 'info' : 
                ($envio->tipo == 'boleto_codigo' ? 'secondary' : 
                ($envio->tipo == 'pix_manual' ? 'primary' : 'dark')))); ?>">
                <?php echo e($envio->tipo_nome); ?>

              </span>
            </td>
            <td class="d-none d-lg-table-cell">
              <span class="badge bg-light text-dark">
                <?php echo e($envio->gateway_name); ?>

              </span>
            </td>
            <td class="d-none d-md-table-cell">
              <?php if($envio->valor): ?>
                <span class="fw-bold text-success">R$ <?php echo e(number_format($envio->valor, 2, ',', '.')); ?></span>
              <?php else: ?>
                <span class="text-muted">-</span>
              <?php endif; ?>
            </td>
            <td>
              <?php if($envio->status == 'sucesso'): ?>
                <span class="badge bg-success d-flex align-items-center justify-content-center">
                  <i class="ri-check-line me-1"></i> Sucesso
                </span>
              <?php elseif($envio->status == 'falha'): ?>
                <span class="badge bg-danger d-flex align-items-center justify-content-center" title="<?php echo e($envio->erro ?? ''); ?>">
                  <i class="ri-close-line me-1"></i> Falha
                </span>
              <?php else: ?>
                <span class="badge bg-warning d-flex align-items-center justify-content-center">
                  <i class="ri-time-line me-1"></i> Pendente
                </span>
              <?php endif; ?>
            </td>
            <td class="d-none d-xl-table-cell">
              <small class="text-truncate-cell"><?php echo e($envio->origem); ?></small>
            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <tr>
            <td colspan="8" class="text-center">Nenhum envio encontrado no período selecionado.</td>
          </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>

<script>
  // Função para controlar exibição dos campos de data personalizada
  function toggleCustomDates() {
    const periodo = document.getElementById('periodoSelect').value;
    const dataInicioDiv = document.getElementById('dataInicioDiv');
    const dataFimDiv = document.getElementById('dataFimDiv');
    
    if (periodo === 'personalizado') {
      dataInicioDiv.style.display = 'block';
      dataFimDiv.style.display = 'block';
    } else {
      dataInicioDiv.style.display = 'none';
      dataFimDiv.style.display = 'none';
    }
  }

  // Variável global para o DataTable
  var table;
  
  // Inicializar DataTable
  $(document).ready(function() {
    // Verificar se a tabela existe e tem dados
    const $table = $('#whatsappTable');
    const $tbody = $table.find('tbody');
    const hasData = $tbody.find('tr').length > 0 && !$tbody.find('tr td[colspan]').length;
    
    if (hasData) {
      // Destruir instância existente se houver
      if ($.fn.DataTable.isDataTable('#whatsappTable')) {
        $('#whatsappTable').DataTable().destroy();
      }
      
      table = $table.DataTable({
        responsive: true,
        order: [[0, 'desc']],
        columnDefs: [
          { 
            targets: 4, // Gateway
            className: 'd-none d-lg-table-cell'
          },
          { 
            targets: 5, // Valor
            className: 'd-none d-md-table-cell'
          },
          { 
            targets: 7, // Origem
            className: 'd-none d-xl-table-cell'
          }
        ],
        language: {
          url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/pt-BR.json',
          paginate: {
            first: '<i class="ri-skip-back-line"></i>',
            previous: '<i class="ri-arrow-left-line"></i>',
            next: '<i class="ri-arrow-right-line"></i>',
            last: '<i class="ri-skip-forward-line"></i>'
          }
        },
        pageLength: 25,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Todos"]],
        dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>' +
             '<"row"<"col-sm-12"tr>>' +
             '<"row"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7"p>>'
      });
    }
    
    // Inicializar estado dos campos de data
    toggleCustomDates();
    
    // Funcionalidade para expandir/contrair texto
    setTimeout(function() {
      $(document).on('click', '.text-truncate-cell', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        const $cell = $(this);
        const $allCells = $('.text-truncate-cell');
        
        // Fechar todas as outras células expandidas
        $allCells.not($cell).removeClass('expanded');
        
        // Alternar estado da célula clicada
        $cell.toggleClass('expanded');
      });
      
      // Fechar células expandidas ao clicar fora
      $(document).on('click', function(e) {
        if (!$(e.target).closest('.text-truncate-cell').length) {
          $('.text-truncate-cell').removeClass('expanded');
        }
      });
      
      // Fechar com ESC
      $(document).on('keydown', function(e) {
        if (e.key === 'Escape') {
          $('.text-truncate-cell').removeClass('expanded');
        }
      });
      
      // Re-aplicar eventos após redraw do DataTable
      if (table) {
        table.on('draw', function() {
          setTimeout(function() {
            // Re-aplicar eventos se necessário
          }, 100);
        });
      }
      
    }, 1000);
  });

  // Gráfico de Envios por Dia
  const ctxDia = document.getElementById('chartEnviosPorDia');
  if (ctxDia) {
    <?php if($enviosPorDia->count() > 0): ?>
    new Chart(ctxDia.getContext('2d'), {
      type: 'line',
      data: {
        labels: [
          <?php $__currentLoopData = $enviosPorDia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          '<?php echo e(\Carbon\Carbon::parse($dia->dia)->format('d/m')); ?>'<?php echo e(!$loop->last ? ',' : ''); ?>

          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ],
        datasets: [{
          label: 'Envios',
          data: [
            <?php $__currentLoopData = $enviosPorDia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo e($dia->total); ?><?php echo e(!$loop->last ? ',' : ''); ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          ],
          borderColor: '#487FFF',
          backgroundColor: 'rgba(72, 127, 255, 0.1)',
          tension: 0.4,
          fill: true
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
          legend: {
            display: true
          }
        }
      }
    });
    <?php else: ?>
    // Sem dados - exibir mensagem
    ctxDia.getContext('2d').fillText('Nenhum dado disponível', 10, 50);
    <?php endif; ?>
  }

  // Gráfico de Pizza - Sucesso vs Falha
  const ctxPizza = document.getElementById('chartSucessoFalha');
  if (ctxPizza) {
    new Chart(ctxPizza.getContext('2d'), {
      type: 'doughnut',
      data: {
        labels: ['Sucesso', 'Falha', 'Pendente'],
        datasets: [{
          data: [
            <?php echo e($enviosSucesso); ?>,
            <?php echo e($enviosFalha); ?>,
            <?php echo e($enviosPendentes); ?>

          ],
          backgroundColor: ['#28a745', '#dc3545', '#ffc107']
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
          legend: {
            position: 'bottom'
          }
        }
      }
    });
  }
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Documentos\Desktop\gestor1.1.0\laravel-gestor\resources\views/relatorios/whatsapp.blade.php ENDPATH**/ ?>