

<?php $__env->startSection('title', 'PDV - Ponto de Venda'); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Estilos dos switches */
.form-switch {
    min-height: 24px;
    padding-left: 0;
}

.form-switch .form-check-input {
    margin-left: 0;
    margin-right: 8px;
}

.form-switch .form-check-label {
    font-size: 14px;
    line-height: 1.2;
}

/* Tabela responsiva e fluida no PDV */
#aReceberTable {
    width: 100%;
    min-width: 750px;
    table-layout: auto;
}

/* Estado bloqueado do PDV */
.pdv-bloqueado {
    pointer-events: none;
    opacity: 0.4;
    position: relative;
}

.pdv-bloqueado::after {
    content: "Caixa fechado";
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    background: rgba(220, 53, 69, 0.9);
    color: #fff;
    padding: 12px 20px;
    border-radius: 8px;
    font-weight: bold;
    font-size: 1.1rem;
    z-index: 10;
    text-align: center;
}

.pdv-summary {
    padding-top: 1rem;
    margin-top: auto;
}

.pdv-summary-item {
    display: flex;
    justify-content: space-between;
    margin-bottom: 0.5rem;
    font-size: 1rem;
}

.pdv-total-final span:last-child {
    font-size: 1.6rem;
    font-weight: bold;
    color: var(--bs-success, #198754);
}

/* Lista de resultados de busca */
.list-group-item {
    cursor: pointer;
    padding: 0.5rem 0.75rem;
    border: none;
    border-bottom: 1px solid var(--bs-border-color, #dee2e6);
    background-color: var(--bs-body-bg, #fff);
    color: var(--bs-body-color, #212529);
}

.list-group-item:last-child {
    border-bottom: none;
}

.list-group-item:hover {
    background-color: var(--bs-tertiary-bg, #f8f9fa);
}

/* Campos obrigatórios */
.campo-obrigatorio-vazio {
    border-color: #dc3545 !important;
    box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important;
}

.campo-obrigatorio-preenchido {
    border-color: #198754 !important;
    box-shadow: 0 0 0 0.2rem rgba(25, 135, 84, 0.25) !important;
}

.caixa-alinhado>div {
    display: flex;
    flex-direction: column;
    justify-content: flex-end;
}

.caixa-alinhado button {
    min-height: 38px;
}

#finalizar-venda:disabled {
    opacity: 0.6;
    cursor: not-allowed;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-main-body">
    <div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
        <h6 class="fw-semibold mb-0">PDV - Ponto de Venda</h6>
        <div class="d-flex align-items-center gap-3">
            <a href="#" class="btn btn-outline-primary btn-sm" onclick="alert('Funcionalidade em desenvolvimento'); return false;">
                <i class="fas fa-qrcode me-1"></i>
                Detalhes do App
            </a>
            <a href="<?php echo e(asset('pdvscanner.apk')); ?>" class="btn btn-outline-warning btn-sm">
                <i class="fab fa-android me-1"></i>
                Baixar App
            </a>
            <button class="btn btn-outline-success btn-sm" data-bs-toggle="modal" data-bs-target="#modalCalculadora">
                <i class="fas fa-calculator me-1"></i>
                Calculadora
            </button>
        </div>
    </div>

    <!-- Main content -->
    <div class="content">
        <div class="container-fluid">
            <!-- Linha de Status (Vendas e Caixa) - Primeira Linha -->
            <div class="row mb-3">
                <!-- VENDAS DE HOJE -->
                <div class="col-md-4">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-2">
                                <i class="fas fa-coins fa-2x text-success me-3"></i>
                                <div class="flex-grow-1">
                                    <p class="text-secondary-light mb-16">Vendas de Hoje (Caixa Atual)</p>
                                    <div class="fs-4 fw-bold text-success">R$ <?php echo e(number_format($vendas_hoje, 2, ',', '.')); ?></div>
                                </div>
                            </div>
                            <div class="text-center mt-3">
                                <button class="btn btn-outline-success btn-sm w-100" id="btn-relatorio-vendas-dia" data-bs-toggle="modal" data-bs-target="#modalRelatorioVendasDia">
                                    <i class="fas fa-chart-line me-1"></i> Ver Relatório Completo
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- STATUS DO CAIXA -->
                <div class="col-md-4">
                    <div class="card shadow-sm h-100">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div class="d-flex align-items-start w-100">
                                <i class="fas fa-cash-register fa-2x text-primary me-3 mt-1"></i>
                                <div class="flex-grow-1">
                                    <div class="text-secondary-light mb-16">Status do Caixa</div>

                                    <?php if($caixa_aberto): ?>
                                        <div class="fw-semibold">Aberto por: <?php echo e($nome_atendente ?? 'N/A'); ?></div>
                                        <div class="text-secondary-light mb-16">Desde: <?php echo e($data_caixa); ?></div>
                                    <?php else: ?>
                                        <div class="fw-semibold text-danger mb-2">Caixa Fechado</div>
                                        <div class="d-flex align-items-end gap-3 flex-wrap caixa-alinhado" style="margin-bottom: 1rem;">
                                            <div>
                                                <label for="atendente-nome" class="form-label small fw-semibold mb-1">Atendente</label>
                                                <select id="atendente-nome" class="form-control form-control-sm w-auto" required>
                                                    <option value="">Selecione o atendente</option>
                                                    <?php $__currentLoopData = $funcionarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $funcionario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($funcionario->nome); ?>"><?php echo e($funcionario->nome); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div>
                                                <label for="saldo-inicial" class="form-label small fw-semibold mb-1">Saldo Inicial (Opcional)</label>
                                                <div class="input-group input-group-sm w-auto">
                                                    <span class="input-group-text">R$</span>
                                                    <input type="text" class="form-control" id="saldo-inicial" placeholder="0,00" onkeyup="formatarMoeda(this)" onkeypress="apenasNumeros(event)">
                                                </div>
                                            </div>
                                            <div>
                                                <button class="btn btn-outline-primary btn-sm" id="abrir-caixa" style="min-height:38px;">Abrir Caixa</button>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="ms-3">
                                    <?php if($caixa_aberto): ?>
                                        <button class="btn btn-danger btn-sm" id="fechar-caixa">Fechar Caixa</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- STATUS TEMPO REAL -->
                <div class="col-md-4">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-2">
                                <i class="fas fa-mobile-alt fa-2x <?php echo e($codigo_tempo_real_ativo ? 'text-success' : 'text-secondary'); ?> me-3"></i>
                                <div class="flex-grow-1">
                                    <p class="text-secondary-light mb-16">App Tempo Real</p>
                                    <?php if($codigo_tempo_real_ativo): ?>
                                        <div class="fw-semibold text-success">Código: <?php echo e($codigo_tempo_real_numero); ?></div>
                                        <div class="text-secondary-light mb-16">Desde: <?php echo e($codigo_tempo_real_data); ?></div>
                                    <?php else: ?>
                                        <div class="fw-semibold text-secondary">Desconectado</div>
                                        <div class="text-secondary-light mb-16">Nenhum código ativo</div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="text-center mt-3">
                                <?php if($codigo_tempo_real_ativo): ?>
                                    <button class="btn btn-outline-success btn-sm w-100" id="btn-status-tempo-real" disabled>
                                        <i class="fas fa-wifi me-1"></i> Tempo Real Ativo
                                    </button>
                                    <small class="d-block mt-1 text-secondary-light">Produtos em tempo real via polling</small>
                                <?php else: ?>
                                    <button class="btn btn-outline-secondary btn-sm w-100" id="btn-ativar-tempo-real">
                                        <i class="fas fa-mobile-alt me-1"></i> Conectar App
                                    </button>
                                    <small class="text-muted d-block mt-1">Clique para gerar código</small>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Segunda Linha de Status (Ações) -->
            <div class="row mb-4">
                <!-- BOTÃO BAIXA DE CONTAS -->
                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body d-flex align-items-center justify-content-center">
                            <div class="text-center">
                                <i class="fas fa-money-bill-wave fa-2x text-warning mb-3"></i>
                                <div class="text-secondary-light mb-16">Baixa de Contas</div>
                                <button class="btn btn-warning btn-lg" id="btn-abrir-modal-baixa" data-bs-toggle="modal" data-bs-target="#modalBaixaContas">
                                    <i class="fas fa-search"></i> <span>Buscar Cliente</span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- BOTÃO GERENCIAR VENDAS -->
                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body d-flex align-items-center justify-content-center">
                            <div class="text-center">
                                <i class="fas fa-exchange-alt fa-2x text-info mb-3"></i>
                                <div class="text-secondary-light mb-16">Gerenciar Vendas</div>
                                <button class="btn btn-info btn-lg" id="btn-abrir-modal-gerenciar" data-bs-toggle="modal" data-bs-target="#modalGerenciarVendas">
                                    <i class="fas fa-cogs"></i> <span>Cancelar/Trocar</span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Conteúdo Principal do PDV -->
            <div class="card card-primary card-outline">
                <div class="card-body p-0">
                    <div class="pdv-conteudo position-relative <?php echo e($caixa_aberto ? '' : 'pdv-bloqueado'); ?>">
                        <div class="p-3">
                            <!-- Campos Cliente e Forma de Pagamento -->
                            <div class="row justify-content-center mb-3">
                                <div class="col-md-6 position-relative">
                                    <label for="busca-cliente" class="form-label small fw-semibold">
                                        Cliente <span class="text-danger">*</span>
                                    </label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="fas fa-user"></i></span>
                                        <input type="text" class="form-control" id="busca-cliente" placeholder="Nome, CPF ou CNPJ (Obrigatório)">
                                    </div>
                                    <div id="clientes-lista" class="list-group position-absolute w-100" style="z-index: 1050; display: none; max-height: 200px; overflow-y: auto; border: 1px solid var(--bs-border-color, #dee2e6); background-color: var(--bs-body-bg, #fff);">
                                    </div>
                                    <input type="hidden" id="cliente-selecionado-id">
                                    <span id="cliente-selecionado-nome" class="text-secondary-light mb-16"></span>
                                </div>

                                <div class="col-md-6">
                                    <label for="forma-pagamento" class="form-label small fw-semibold">
                                        Forma de Pagamento <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select" id="forma-pagamento">
                                        <option value="">Selecione...</option>
                                        <?php $__currentLoopData = $formas_pagamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($fp->id); ?>"><?php echo e($fp->nome); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <!-- Switches -->
                            <div class="row justify-content-center align-items-center mb-3">
                                <div class="col-md-6 text-center">
                                    <div class="form-switch switch-success d-flex align-items-center justify-content-center gap-3">
                                        <input class="form-check-input" type="checkbox" role="switch" id="lancar-conta-switch" checked>
                                        <label class="form-check-label line-height-1 fw-medium text-secondary-light" for="lancar-conta-switch">
                                            Lançar cobrança no Contas a Receber?
                                        </label>
                                    </div>
                                </div>

                                <div class="col-md-6 text-center">
                                    <div class="form-switch switch-success d-flex align-items-center justify-content-center gap-3">
                                        <input class="form-check-input" type="checkbox" role="switch" id="enviar-comprovante-whatsapp" checked>
                                        <label class="form-check-label line-height-1 fw-medium text-secondary-light" for="enviar-comprovante-whatsapp">
                                            Enviar comprovante via WhatsApp?
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- Campos de Conta a Receber -->
                            <div id="campos-conta-receber" class="row justify-content-center" style="display: flex;">
                                <div class="col-md-4">
                                    <label for="parcelas" class="form-label small fw-semibold">Quantidade de Parcelas</label>
                                    <input type="number" name="parcelas" id="parcelas" class="form-control" min="1" max="12" value="1">
                                </div>
                                <div class="col-md-4">
                                    <label for="ciclo-pagamento" class="form-label small fw-semibold">Ciclo de Pagamento</label>
                                    <select class="form-select" id="ciclo-pagamento" name="ciclo_pagamento" required>
                                        <option value="">Selecione...</option>
                                        <?php $__currentLoopData = $ciclos_pagamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ciclo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($ciclo->id); ?>" data-dias="<?php echo e($ciclo->dias); ?>"><?php echo e($ciclo->nome); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label for="data-vencimento" class="form-label small fw-semibold">Data de Vencimento</label>
                                    <input type="date" name="data_vencimento" id="data-vencimento" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" required>
                                </div>
                            </div>

                            <!-- Campo Buscar Produtos -->
                            <div class="row justify-content-center mb-4 mt-5">
                                <div class="col-md-8">
                                    <h5 class="mb-3 text-center">Buscar Produtos</h5>
                                    <div class="mb-3 position-relative">
                                        <label for="busca-produto" class="form-label small fw-semibold">Nome ou Código do Produto</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fas fa-search"></i></span>
                                            <input type="text" class="form-control" id="busca-produto" placeholder="Digite para buscar...">
                                        </div>
                                        <div id="resultado-produtos" class="list-group position-absolute w-100" style="z-index: 1050; display: none; max-height: 300px; overflow-y: auto; border: 1px solid var(--bs-border-color, #dee2e6); background-color: var(--bs-body-bg, #fff);">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Carrinho -->
                            <div class="row justify-content-center">
                                <div class="col-12">
                                    <h5 class="text-center mb-3"><i class="fas fa-basket-shopping mr-1"></i> Carrinho</h5>
                                    <div class="table-responsive mb-3" style="overflow-x: auto; max-height: 300px; overflow-y: auto;">
                                        <table class="table bordered-table mb-0 display responsive nowrap w-100" id="aReceberTable" data-page-length='10'>
                                            <thead class="thead-light">
                                                <tr>
                                                    <th scope="col">Produto</th>
                                                    <th scope="col" class="text-center" style="width: 80px;">Qtd</th>
                                                    <th scope="col" class="text-end" style="width: 110px;">Preço Unit.</th>
                                                    <th scope="col" class="text-end" style="width: 110px;">Total Item</th>
                                                    <th scope="col" class="text-center" style="width: 60px;">Ações</th>
                                                </tr>
                                            </thead>
                                            <tbody id="pdv-carrinho">
                                                <tr id="carrinho-vazio-placeholder">
                                                    <td colspan="5" class="text-center text-muted py-4">
                                                        <i class="fas fa-shopping-cart fa-2x mb-2"></i><br>
                                                        Carrinho vazio
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                    <!-- Resumo da Venda -->
                                    <div class="pdv-summary mt-auto">
                                        <div class="pdv-summary-item">
                                            <div class="text-secondary-light mb-16">Subtotal</div>
                                            <span id="pdv-subtotal">R$ 0,00</span>
                                        </div>
                                        <div class="pdv-summary-item d-flex justify-content-between align-items-center">
                                            <div class="text-secondary-light mb-16">Desconto</div>
                                            <span>
                                                <input type="text" id="pdv-desconto" class="form-control form-control-sm text-end" style="width: 120px;" placeholder="" value="">
                                            </span>
                                        </div>
                                        <hr class="my-2">
                                        <div class="pdv-summary-item pdv-total-final mb-3">
                                            <div class="text-secondary-light mb-16">Total</div>
                                            <span id="pdv-total">R$ 0,00</span>
                                        </div>
                                        <button class="btn btn-success btn-lg w-100" id="finalizar-venda" disabled title="Para finalizar a venda, você precisa: 1) Adicionar produtos ao carrinho, 2) Selecionar um cliente, 3) Escolher uma forma de pagamento">
                                            Finalizar Venda
                                        </button>
                                        <small class="text-secondary-light mt-2 d-block text-center">
                                            <i class="fas fa-info-circle"></i> Cliente, produtos e forma de pagamento são obrigatórios
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modais serão adicionados aqui -->
<?php echo $__env->make('pdv.modals.calculadora', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('pdv.modals.baixa-contas', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('pdv.modals.gerenciar-vendas', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('pdv.modals.relatorio-vendas-dia', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Variáveis globais
const CAIXA_ID = <?php echo e($caixa_aberto_id ?? 'null'); ?>;
const IDM = <?php echo e(Auth::user()->id); ?>;
const CODIGO_TEMPO_REAL_ATIVO = <?php echo e($codigo_tempo_real_ativo ? 'true' : 'false'); ?>;

// Configuração Toastr
toastr.options = {
    closeButton: true,
    debug: false,
    newestOnTop: true,
    progressBar: true,
    positionClass: "toast-top-right",
    preventDuplicates: false,
    onclick: null,
    showDuration: "300",
    hideDuration: "1000",
    timeOut: "5000",
    extendedTimeOut: "1000",
    showEasing: "swing",
    hideEasing: "linear",
    showMethod: "fadeIn",
    hideMethod: "fadeOut"
};

// Funções auxiliares
function formatarMoeda(input) {
    let valor = input.value.replace(/\D/g, '');
    valor = (valor / 100).toFixed(2) + '';
    valor = valor.replace(".", ",");
    valor = valor.replace(/\B(?=(\d{3})+(?!\d))/g, ".");
    input.value = valor;
}

function apenasNumeros(event) {
    const charCode = (event.which) ? event.which : event.keyCode;
    if (charCode > 31 && (charCode < 48 || charCode > 57)) {
        return false;
    }
    return true;
}

// Abrir caixa
$(document).ready(function() {
    $('#abrir-caixa').on('click', function() {
        const atendenteNome = $('#atendente-nome').val();
        const saldoInicial = $('#saldo-inicial').val().replace(/\./g, '').replace(',', '.');

        if (!atendenteNome) {
            toastr.error('Por favor, selecione um atendente');
            return;
        }

        $.ajax({
            url: '<?php echo e(route("pdv.caixa.abrir")); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                atendente_nome: atendenteNome,
                saldo_inicial: saldoInicial || 0
            },
            success: function(response) {
                toastr.success('Caixa aberto com sucesso!');
                setTimeout(function() {
                    location.reload();
                }, 1000);
            },
            error: function(xhr) {
                const error = xhr.responseJSON?.message || xhr.responseJSON?.error || 'Erro ao abrir caixa';
                toastr.error(error);
            }
        });
    });

    // Fechar caixa
    $('#fechar-caixa').on('click', function() {
        if (!confirm('Tem certeza que deseja fechar o caixa?')) {
            return;
        }

        $.ajax({
            url: '<?php echo e(route("pdv.caixa.fechar", ":id")); ?>'.replace(':id', CAIXA_ID),
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                _method: 'POST'
            },
            success: function(response) {
                toastr.success('Caixa fechado com sucesso!');
                setTimeout(function() {
                    location.reload();
                }, 1000);
            },
            error: function(xhr) {
                const error = xhr.responseJSON?.message || xhr.responseJSON?.error || 'Erro ao fechar caixa';
                toastr.error(error);
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Documentos\Desktop\gestor1.1.0\laravel-gestor\resources\views/pdv/index.blade.php ENDPATH**/ ?>