<?php
    $superAdmin = \App\Models\Carteira::find(1);
    $nomeSistema = $superAdmin ? $superAdmin->nomecom : config('app.name');
    $favicon = $superAdmin && $superAdmin->favicon ? asset($superAdmin->favicon) : asset('img/favicon_default.png');
    
    // Verificar dark mode - usar theme se existir, senão usar dark_mode
    $isDarkMode = Auth::user()->theme === 'dark' || (Auth::user()->dark_mode ?? false);
    $themeValue = Auth::user()->theme ?? ($isDarkMode ? 'dark' : 'light');
    
    // Verificar expiração de licença
    $user = Auth::user();
    $hoje = \Carbon\Carbon::now();
    $dataExpiracao = $user->assinatura ? \Carbon\Carbon::createFromFormat('d/m/Y', $user->assinatura) : null;
    $paginaAtual = request()->path();
?>

<!DOCTYPE html>
<html lang="pt-BR" data-theme="<?php echo e($themeValue); ?>">

<?php echo $__env->make('partials.head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<body>
    <!-- Loader -->
    <div id="loader" style="position: fixed; width: 100%; height: 100%; background: white; display: flex; align-items: center; justify-content: center; z-index: 9999;">
        <div class="col-3" style="display: flex; align-items: center; justify-content: center;">
            <div class="snippet" data-title="loader">
                <div class="stage">
                    <div class="loader"></div>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->make('layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <main class="dashboard-main">
        <?php echo $__env->make('partials.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <div class="dashboard-main-body">
            <?php echo $__env->yieldContent('content'); ?>
        </div>

        <?php echo $__env->make('partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </main>

    <?php echo $__env->make('partials.scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>

    
    <?php if(
        $user->tipo != 1 && // Não é superadmin
        !session('is_funcionario') && // Não é funcionário
        $dataExpiracao && $hoje->greaterThanOrEqualTo($dataExpiracao) &&
        $paginaAtual != 'master/planos' &&
        !Str::contains($paginaAtual, 'sair')
    ): ?>
        <!-- MODAL BLOQUEADO DE LICENÇA EXPIRADA -->
        <div id="modalLicencaExpirada" class="modal fade" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-danger text-white">
                        <h5 class="modal-title">Licença Expirada</h5>
                    </div>
                    <div class="modal-body">
                        <p>Sua licença expirou. Renove agora para continuar usando os serviços.</p>
                    </div>
                    <div class="modal-footer">
                        <button id="btnRenovar" class="btn btn-danger">Renovar agora</button>
                    </div>
                </div>
            </div>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
                setTimeout(function () {
                    if (typeof $ !== "undefined" && typeof $.fn.modal !== "undefined") {
                        const $modal = $('#modalLicencaExpirada');
                        $modal.modal({
                            backdrop: 'static',
                            keyboard: false
                        });
                        $modal.modal('show');
                        document.getElementById("btnRenovar").addEventListener("click", function () {
                            window.location.href = "<?php echo e(route('planos.index')); ?>";
                        });
                    } else {
                        window.location.href = "<?php echo e(route('planos.index')); ?>";
                    }
                }, 300);
            });
        </script>
    <?php endif; ?>

    <script>
        // Dark Mode Toggle
        function toggleDarkMode() {
            var body = document.body;
            var html = document.documentElement;
            var icon = document.getElementById('darkModeIcon');
            
            body.classList.toggle('dark-mode');
            var newTheme = body.classList.contains('dark-mode') ? 'dark' : 'light';
            html.setAttribute('data-theme', newTheme);
            
            if (newTheme === 'dark') {
                icon.src = "<?php echo e(asset('icon/luaa.png')); ?>";
            } else {
                icon.src = "<?php echo e(asset('icon/sol.png')); ?>";
            }
            
            localStorage.setItem('mode', newTheme);
            
            // Salva no banco via Ajax
            $.ajax({
                url: '<?php echo e(route("configuracoes.toggle-theme")); ?>',
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(response) {
                    console.log('Tema alterado para: ' + response.theme);
                }
            });
        }

        // Load Dark Mode Preference
        window.onload = function() {
            var body = document.body;
            var html = document.documentElement;
            var icon = document.getElementById('darkModeIcon');
            var mode = localStorage.getItem('mode') || '<?php echo e($themeValue); ?>';
            
            if (mode === 'dark') {
                body.classList.add('dark-mode');
                html.setAttribute('data-theme', 'dark');
                if (icon) icon.src = "<?php echo e(asset('icon/luaa.png')); ?>";
            } else {
                body.classList.remove('dark-mode');
                html.setAttribute('data-theme', 'light');
                if (icon) icon.src = "<?php echo e(asset('icon/sol.png')); ?>";
            }
            
            // Hide loader
            setTimeout(function() {
                var loader = document.getElementById('loader');
                if (loader) loader.style.display = 'none';
            }, 1000);
        }

        // Confirm delete
        function pergunta() {
            return confirm('Tem certeza que deseja excluir?');
        }
    </script>
</body>
</html>
<?php /**PATH D:\Documentos\Desktop\gestor1.1.0\laravel-gestor\resources\views/layouts/app.blade.php ENDPATH**/ ?>